/*
 * @Author: WangJiaCheng
 * @Date: 2021-07-09 15:43:50
 * @LastEditors: WangJiaCheng
 * @LastEditTime: 2021-07-16 10:37:39
 * @Description:
 */
import Vue from 'vue'
import Vuex from 'vuex'

// import app from './modules/app'
// import page from './modules/page'

Vue.use(Vuex)

const modulesFiles = require.context('./modules/', true, /\.js$/)

const modules = modulesFiles.keys().reduce((ms, modulePath) => {
  // set './app.js' => 'app'
  const moduleName = modulePath.replace(/^\.\/(.*)\.\w+$/, '$1')
  const value = modulesFiles(modulePath)
  ms[moduleName] = value.default
  return ms
}, {})

const store = new Vuex.Store({
  namespaced: true,
  modules
})

export default store
