import Vue from 'vue'
import VueRouter from 'vue-router'

import DefaultLayout from '@/layouts/DefaultLayout/index.vue'

import page from './modules/page'
import form from './modules/form'
import template from './modules/template'
import list from './modules/list'
import editor from './modules/editor'

// 全局处理路由导航重复
const originalPush = VueRouter.prototype.push
VueRouter.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject) return originalPush.call(this, location, onResolve, onReject)
  return originalPush.call(this, location).catch(err => err)
}

Vue.use(VueRouter)

export const routes = [
  {
    path: '/',
    component: DefaultLayout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: () => import(/* webpackChunkName: "dashboard" */ '@/views/dashboard/index.vue'),
        name: 'Dashboard',
        meta: {
          title: '首页',
          icon: 'dashboard',
          affix: true
        }
      }
    ]
  },
  ...page,
  ...template,
  ...form,
  ...list,
  ...editor,
  {
    path: '/tinymce',
    name: 'tinymce',
    component: DefaultLayout,
    redirect: 'tinymce',
    children: [
      {
        path: '/index',
        name: 'tinymceText',
        meta: {
          title: '富文本'
        },
        component: () => import(/* webpackChunkName: "tinymce-example" */'@/components/tinymce/example/Index.vue')
      }
    ]
  }
]

const router = new VueRouter({
  routes,
  mode: 'history'
})

export default router
