/*
 * @Author: WangJiaCheng
 * @Date: 2021-05-07 11:34:26
 * @LastEditors: wjc
 * @LastEditTime: 2021-09-16 15:06:09
 * @Description:  入口
 */
import Vue from 'vue'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import WisdomUI from 'wisdom-ui'
import 'wisdom-ui/lib/theme/index.css'

import App from './App.vue'
import router from '@/router'
import store from '@/store'
import '@/styles/index.less'
import '@/icons'
import axios from 'axios'
import Tinymce from '@/components/tinymce/index.vue'

Vue.component('tinymce', Tinymce)

Vue.config.productionTip = false
Vue.prototype.$axios = axios

Vue.use(ElementUI, { size: 'small' })
Vue.use(WisdomUI)

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
