/*
 * @Author: WangJiaCheng
 * @Date: 2021-07-29 11:19:04
 * @LastEditors: wjc
 * @LastEditTime: 2021-12-08 18:06:10
 * @Description: tabs 配置
 */
import { exportDefault } from '@/utils/index'

export function buildTabs(formData) {
  const { list = [] } = formData
  const str = `
  <div class="tab">
    ${buildHeader(formData)}
    <search-form
      ref="searchForm"
      @search="handleSearch"
      @reset="handleReset"
    />
    <data-table
      ref="dataTable"
      :loading="tableLoading"
      @page="handlePage"
    />
  </div>
  `
  return str
}

function buildHeader(data) {
  const btn = []
  if (data.btn && data.btn.length > 0) {
    data.btn.forEach((item, index) => {
      btn.push(`<el-button size="small" ${index === 0 ? 'type="primary"' : ''} @click="handleClick${index}">
        ${item}
      </el-button>`)
    })
  }
  const str = `<w-header
    desc="${data.headerDesc}"
  >
    ${btn.length > 0 ? `<template v-slot:right>${btn.join('')}</template>` : ''}
  </w-header>`
  return str
}

export function makeTabsJs(formData) {
  const str = `
  import SearchForm from './components/search_from'
  import DataTable from './components/data_table'

  ${exportDefault} {
    name: 'Tab',
    components: {
      SearchForm,
      DataTable,
    },
    props: {
      activeTab: String
    },
    data () {
      return {
        tableLoading: false,
        page: {
          pageSize: 20,
          pageNum: 1
        }
      }
    },
    mounted () {
    },
    methods: {
      getList (data = {}) {
        this.tableLoading = true
      },
      handlePage (data) {
        this.page = { ...this.page, ...data }
        this.getList()
      },
      handleSearch (query) {
        this.tableLoading = true
        this.page.pageNum = 1
        this.getList(query)
      },
      handleReset () {
        this.tableLoading = true
        this.page.pageNum = 1
        this.getList()
      }
    }
  }`
  return str
}
