/*
 * @Author: WangJiaCheng
 * @Date: 2021-07-26 14:27:27
 * @LastEditors: WangJiaCheng
 * @LastEditTime: 2021-08-20 14:12:11
 * @Description: table生成
 */
import { exportDefault, titleCase, deepClone } from '@/utils/index'

export function buildTable(formData) {
  const { list = [] } = formData
  const child = list.map(item => `<el-table-column prop="${item.field}" label="${item.name}"></el-table-column>`)
    .join('\n')
  const str = `<w-table
    v-loading="loading"
    :data="tableData"
    @size-change="sizeChange"
    @page-change="currentChange"
  >${child}</w-table>`
  return str
}

export function makeTableJs(formData) {
  const str = `
    ${exportDefault} {
    name: 'DataTable',
    props: {
      loading: Boolean,
      tableData: {
        type: Object,
        default () {
          return {
            list: [],
            pageSize: 20,
            pageNum: 1,
            total: 0
          }
        }
      }
    },
    data () {
      return {
      }
    },
    methods: {
      sizeChange (pageSize) {
        this.$emit('page', { pageSize })
      },
      currentChange (pageNum) {
        this.$emit('page', { pageNum })
      }
    }
  }`
  return str
}
