/*
 * @Author: Wzh
 * @Date: 2020-06-15 10:35:27
 * @LastEditors: Wzh
 * @LastEditTime: 2020-06-16 14:32:01
 * @Description: 工具类
 */

/**
 * @description 绑定事件 on(element, event, handler)
 */
export const on = (function () {
  if (document.addEventListener) {
    return function (element, event, handler, useCapture = false) {
      if (element && event && handler) {
        element.addEventListener(event, handler, useCapture)
      }
    }
  }
  return function (element, event, handler) {
    if (element && event && handler) {
      element.attachEvent(`on${event}`, handler)
    }
  }
}())

/**
 * @description 解绑事件 off(element, event, handler)
 */
export const off = (function () {
  if (document.removeEventListener) {
    return function (element, event, handler, useCapture = false) {
      if (element && event) {
        element.removeEventListener(event, handler, useCapture)
      }
    }
  }
  return function (element, event, handler) {
    if (element && event) {
      element.detachEvent(`on${event}`, handler)
    }
  }
}())

/**
 * 函数防抖
 * @param method {function} 防抖函数
 * @param delay {number} 防抖时间
 */
export const debounce = (method, delay) => {
  let timer = null
  return function (...args) {
    const context = this
    clearTimeout(timer)
    timer = setTimeout(() => {
      method.apply(context, args)
    }, delay)
  }
}

/**
 * 函数节流
 * @param method {function} 节流函数
 * @param delay {number} 节流时间
 */
export const throttle = (func, wait) => {
  let previous = 0
  return function (...args) {
    const now = Date.now()
    const context = this
    if (now - previous > wait) {
      func.apply(context, args)
      previous = now
    }
  }
}
