export default function request(url, options) {
  const defaultOptions = {
    withCredentials: true // 允许跨域
  }
  const reqOptions = { ...defaultOptions, ...options }

  if (
    reqOptions.method === 'POST'
        || reqOptions.method === 'PUT'
        || reqOptions.method === 'DELETE'
        || reqOptions.method === 'PATCH'
  ) {
    if (!(reqOptions.body instanceof FormData)) {
      reqOptions.headers = {
        Accept: 'application/json',
        'Content-Type': 'application/json; charset=utf-8',
        ...reqOptions.headers
      }
    } else {
      reqOptions.headers = {
        ...reqOptions.headers
      }
    }
  }
  return fetch(url, reqOptions)
    .then((res) => {
      if (res.ok) {
        return res.json()
      }
      throw new Error('Network response was not ok.')
    })
    .catch((error) => console.error('Error', error))
}
