/*
 * @Author: MoZhuangRu
 * @Date: 2020-04-24 17:35:48
 * @LastEditors: WangJiaCheng
 * @LastEditTime: 2020-08-24 15:57:41
 * @Description:
 */
module.exports = {
    root: true,

    env: {
        node: true
    },
    rules: {
        'no-console': process.env.NODE_ENV === 'production' ? 'warn' : 'off',
        'no-debugger': process.env.NODE_ENV === 'production' ? 'warn' : 'off',
        'import/prefer-default-export': [0],
        'no-restricted-syntax': [0],
        'no-prototype-builtins': [0],
        'import/no-unresolved': [0],
        // 不允许行末有分号
        semi: [2, 'never'],
        'import/extensions': [0],
        // 不允许数组和对象键值对带末尾的逗号
        'comma-dangle': [2, 'never'],
        'arrow-parens': [0],
        'space-before-function-paren': [0],
        'linebreak-style': [0, 'off', 'windows'],
        'no-underscore-dangle': [0],
        'object-curly-newline': [0],
        'func-names': [0],
        // 强制使用一致的缩进
        indent: [2, 2, { SwitchCase: 1 }],
        // 不允许多个空行
        'no-multiple-empty-lines': [2, { max: 1 }]
    },

    extends: ['plugin:vue/essential', '@vue/airbnb'],

    plugins: [
        'html', // .html 的js代码
        'vue' // .vue文件中的js代码
    ],

    parserOptions: {
        parser: 'babel-eslint'
    }
};
