"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.search = void 0;
const util_1 = require("./util");
const GalleryInterfaces_1 = require("azure-devops-node-api/interfaces/GalleryInterfaces");
const viewutils_1 = require("./viewutils");
const pageSize = 100;
const installationTarget = 'Microsoft.VisualStudio.Code';
const excludeFlags = '37888'; //Value to exclude un-published, locked or hidden extensions
async function search(searchText, json = false) {
    const api = (0, util_1.getPublicGalleryAPI)();
    const results = (await api.extensionQuery({
        pageSize,
        criteria: [
            { filterType: GalleryInterfaces_1.ExtensionQueryFilterType.SearchText, value: searchText },
            { filterType: GalleryInterfaces_1.ExtensionQueryFilterType.InstallationTarget, value: installationTarget },
            { filterType: GalleryInterfaces_1.ExtensionQueryFilterType.ExcludeWithFlags, value: excludeFlags },
        ],
        flags: [GalleryInterfaces_1.ExtensionQueryFlags.ExcludeNonValidated, GalleryInterfaces_1.ExtensionQueryFlags.IncludeLatestVersionOnly],
    }));
    if (json) {
        console.log(JSON.stringify(results, undefined, '\t'));
        return;
    }
    if (!results.length) {
        console.log('No matching results');
        return;
    }
    console.log([
        `Search results:`,
        '',
        ...(0, viewutils_1.tableView)([
            ['<ExtensionId>', '<Description>'],
            ...results.map(({ publisher: { publisherName }, extensionName, shortDescription }) => [
                publisherName + '.' + extensionName,
                (shortDescription || '').replace(/\n|\r|\t/g, ' '),
            ]),
        ]),
        '',
        'For more information on an extension use "vsce show <extensionId>"',
    ]
        .map(line => (0, viewutils_1.wordTrim)(line.replace(/\s+$/g, '')))
        .join('\n'));
}
exports.search = search;
//# sourceMappingURL=search.js.map