/*
 * @Author: wjc
 * @Date: 2021-12-16 11:07:13
 * @LastEditors: wjc
 * @LastEditTime: 2021-12-16 15:14:55
 * @Description:
 */
/* eslint-disable */
import * as path from 'path'
import * as vscode from 'vscode'

const fs = require('fs')

/**
 * 从某个HTML文件读取能被Webview加载的HTML内容
 * @param {*} context 上下文
 * @param {*} templatePath 相对于插件根目录的html文件相对路径
 */
export function getWebViewContent(context, templatePath) {
  const resourcePath = path.join(context.extensionPath, templatePath)
  const dirPath = path.dirname(resourcePath)
  let html = fs.readFileSync(resourcePath, 'utf-8')
  // vscode不支持直接加载本地资源，需要替换成其专有路径格式，这里只是简单的将样式和JS的路径替换
  // /(<link.+?href=(?!http)|<script.+?src=(?!http)|<img.+?src="(?!http)|url\("(?!http))(.+?)[\s|>]/g
  html = html.replace(/(<link.+?href=(?!http))(.+?)\s/g, (m, $1, $2) => {
    return $1 + '"' + vscode.Uri.file(path.resolve(dirPath, $2)).with({ scheme: 'vscode-resource' }).toString() + '" '
  })
  html = html.replace(/(<script.+?src=(?!http))(.+?)>/g, (m, $1, $2) => {
    return $1 + '"' + vscode.Uri.file(path.resolve(dirPath, $2)).with({ scheme: 'vscode-resource' }).toString() + '"> '
  })
  html = html.replace(/(<img.+?src="(?!http)|url\("(?!http))(.+?)"/g, (m, $1, $2) => {
    return $1 + vscode.Uri.file(path.resolve(dirPath, $2)).with({ scheme: 'vscode-resource' }).toString() + '"'
  })
  return html
}

export async function resolveHandle(message, panel) {
  console.log('接收到webview信息', message)
  if (message.command === 'getCurrInterface') {
    panel.webview.postMessage(Object.assign(message, { command: 'reject', data: '未选择保存路径，取消生成' }))
    return
  }
  if (message.command === 'saveQueryPageFile') {
    panel.webview.postMessage(Object.assign(message, { data: 'ok' }))
    return
  }
  if (message.command === 'saveTypingFile') {
    panel.webview.postMessage(Object.assign(message, { data: 'ok' }))
    return
  }
  if (message.command === 'saveEditPageFile') {
    panel.webview.postMessage(Object.assign(message, { data: 'ok' }))
    return
  }
}
